classdef class_REVS_ALPHAshift_CVT
	%class_REVS_ALPHAshift
	%   defines parameters for use with ALPHAshift shift algorithm
	
	properties

		
		min_bsfc_speed_rapds;			% Optimal Efficiency line speeds [radps]
		min_bsfc_power_W;				% Optimal efficiency line powers [W]
		
		min_speed_radps;				% Minimum allowed operational speeds - Dynamic Lookup
	end
	
	methods
		function obj = class_REVS_ALPHAshift_CVT( engine )
			
			if nargin >= 1

				% Use engine map to set optimal speed points - could include adjustment for transmission losses
				[obj.min_bsfc_speed_rapds, ~, obj.min_bsfc_power_W] = REVS_calc_engine_min_bsfc(engine,'increment', 2.5);

			end

		end
		
	
	end
	
end
